# Calculator Suite

A modular collection of browser-based calculators and converters built with **HTML, CSS, and Vanilla JavaScript**.  
Each tool lives in its own folder for clean organization, easy hosting (GitHub Pages / shared hosting), and portfolio presentation.

## Live Hub
Open the suite hub page (landing) from your hosting folder, then navigate to each tool.

## Included Tools

| Tool | Folder | What it does |
|------|--------|--------------|
| Scientific Calculator | `scientific-calculator/` | Trigonometry, logs, memory keys, history, RAD/DEG |
| BMI & Weight Calculator | `bmi-weight-calculator/` | BMI, healthy range, target weight |
| BMR & TDEE Planner | `bmr-tdee-calculator/` | BMR, TDEE, calorie goals, macros guidance |
| Body Fat Calculator | `body-fat-calculator/` | US Navy BF%, lean mass, fat mass |
| Unit Converter | `unit-converter/` | Length, mass, time conversions |
| Loan / Mortgage Calculator | `loan-mortgage-calculator/` | EMI/monthly payment, totals, breakdown |
| Date & Time Calculator | `date-time-calculator/` | Date difference + add/subtract duration |
| Data & Bandwidth Tool | `data-bandwidth-calculator/` | Bits/bytes, base-10 vs base-2, download time |

## Tech Stack
- HTML5
- CSS3 (modern UI)
- Vanilla JavaScript (no frameworks)

## Repo Structure
Each tool is isolated with its own `index.html` and `README.md`:

- Simple to maintain
- Easy to publish to GitHub Pages
- Easy for recruiters to review

## Notes
- These tools are **client-side only** (no database, no tracking).
- Formulas and conversions are implemented for learning + practical use.

## License
MIT (recommended) — feel free to add a LICENSE file at the repo root.
