# Job Application Tracker (Offline)

A lightweight, offline-first job application tracker built with Vanilla JavaScript.  
Keeps your applications organized in a simple pipeline board — no account, no backend.

## Features
- Pipeline board: Applied → Interview → Offer → Rejected → Archived
- Add / edit / delete applications
- Search + status filter + sorting
- Follow-up due badges (optional follow-up days per application)
- Export backups (JSON + CSV)
- Import JSON (merge or replace)
- Theme toggle (dark/light)
- Works fully offline (LocalStorage)

## Tech
- HTML + CSS + Vanilla JS
- Browser LocalStorage for persistence

## Run locally
Just open `index.html` in your browser.

If you prefer a simple local server:
- VS Code: “Live Server”
- Or: `python -m http.server` then open `http://localhost:8000`

## Data storage
All data is stored in your browser via LocalStorage under a single key.  
To move data between devices, use **Export JSON** and **Import**.

## GitHub Pages (free hosting)
1. Push this repo to GitHub
2. Repo → **Settings** → **Pages**
3. Source: **Deploy from a branch**
4. Branch: `main` (root) → Save  
Your site will be available at: `https://<username>.github.io/<repo>/`

## Import format
You can import either:
- An array of application objects
- Or an object like: `{ "items": [ ... ] }`

Minimal fields expected per item: `company`, `role`  
Other supported fields: `status`, `appliedDate`, `link`, `followUpDays`, `contact`, `notes`, `createdAt`, `updatedAt`

## License
MIT (optional). Use whatever license you prefer.
