<?php

declare(strict_types=1);

require dirname(__DIR__) . '/vendor/autoload.php';

use App\Database\DB;
use App\Session\SessionManager;
use App\Middleware\Csrf;
use App\Middleware\AuthGuard;

$config = require dirname(__DIR__) . '/config/app.php';

DB::connect($config['db']);
SessionManager::start($config['session']);

if (!empty($_COOKIE['remember_token']) && !AuthGuard::isLoggedIn()) {
    \App\Auth\Auth::loginFromRememberToken($_COOKIE['remember_token']);
}

$path   = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    Csrf::check();
}

$routes = [
    'GET' => [
        '/'                  => 'home',
        '/login'             => 'auth/login',
        '/register'          => 'auth/register',
        '/forgot-password'   => 'auth/forgot-password',
        '/reset-password'    => 'auth/reset-password',
        '/2fa/verify'        => 'auth/2fa-verify',
        '/dashboard'         => 'dashboard/index',
        '/settings'          => 'dashboard/settings',
        '/settings/2fa'      => 'dashboard/2fa-setup',
        '/logout'            => 'auth/logout',
    ],
    'POST' => [
        '/login'             => 'auth/login-handler',
        '/register'          => 'auth/register-handler',
        '/forgot-password'   => 'auth/forgot-password-handler',
        '/reset-password'    => 'auth/reset-password-handler',
        '/2fa/verify'        => 'auth/2fa-verify-handler',
        '/settings/2fa'      => 'dashboard/2fa-setup-handler',
        '/settings/2fa/disable' => 'dashboard/2fa-disable-handler',
        '/settings/password' => 'dashboard/password-handler',
    ],
];

$handler = $routes[$method][$path] ?? null;

if ($handler === null) {
    http_response_code(404);
    echo '404 — Page not found.';
    exit;
}

$handlerFile = dirname(__DIR__) . "/templates/{$handler}.php";

if (!file_exists($handlerFile)) {
    http_response_code(500);
    echo '500 — Handler not found.';
    exit;
}

require $handlerFile;
