<?php

declare(strict_types=1);

namespace App\Auth;

use App\Database\DB;

class AuditLog
{
    public const LOGIN_SUCCESS     = 'login_success';
    public const LOGIN_FAILED      = 'login_failed';
    public const LOGOUT             = 'logout';
    public const REGISTER          = 'register';
    public const PASSWORD_RESET_REQUEST = 'password_reset_request';
    public const PASSWORD_RESET    = 'password_reset';
    public const PASSWORD_CHANGED  = 'password_changed';
    public const TWO_FA_ENABLED    = '2fa_enabled';
    public const TWO_FA_DISABLED   = '2fa_disabled';
    public const TWO_FA_VERIFIED   = '2fa_verified';
    public const TWO_FA_FAILED     = '2fa_failed';
    public const ACCOUNT_LOCKED    = 'account_locked';
    public const ACCOUNT_UNLOCKED  = 'account_unlocked';

    public static function log(string $event, ?int $userId = null, array $meta = []): void
    {
        DB::insert('audit_logs', [
            'user_id'    => $userId,
            'event'      => $event,
            'ip_address' => $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0',
            'user_agent' => substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 500),
            'meta'       => !empty($meta) ? json_encode($meta) : null,
            'created_at' => date('Y-m-d H:i:s'),
        ]);
    }

    public static function forUser(int $userId, int $limit = 50): array
    {
        return DB::fetchAll(
            'SELECT * FROM audit_logs WHERE user_id = ? ORDER BY created_at DESC LIMIT ?',
            [$userId, $limit]
        );
    }
}
