<?php

declare(strict_types=1);

namespace App\Middleware;

use App\Session\SessionManager;

class AuthGuard
{
    public static function requireAuth(): void
    {
        if (!SessionManager::has('user_id')) {
            SessionManager::flash('error', 'Please log in to continue.');
            header('Location: /login');
            exit;
        }

        if (!SessionManager::validateFingerprint()) {
            SessionManager::destroy();
            session_start();
            SessionManager::flash('error', 'Session expired. Please log in again.');
            header('Location: /login');
            exit;
        }
    }

    public static function requireGuest(): void
    {
        if (SessionManager::has('user_id')) {
            header('Location: /dashboard');
            exit;
        }
    }

    public static function userId(): ?int
    {
        return SessionManager::get('user_id');
    }

    public static function isLoggedIn(): bool
    {
        return SessionManager::has('user_id');
    }
}
