<?php

declare(strict_types=1);

namespace App\Middleware;

use App\Session\SessionManager;

class Csrf
{
    public static function token(): string
    {
        if (!SessionManager::has('_csrf_token')) {
            SessionManager::set('_csrf_token', bin2hex(random_bytes(32)));
        }
        return SessionManager::get('_csrf_token');
    }

    public static function field(): string
    {
        return '<input type="hidden" name="_csrf_token" value="' . self::token() . '">';
    }

    public static function validate(): bool
    {
        $token = $_POST['_csrf_token'] ?? '';
        $stored = SessionManager::get('_csrf_token', '');

        if (empty($token) || empty($stored)) {
            return false;
        }

        return hash_equals($stored, $token);
    }

    public static function check(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && !self::validate()) {
            http_response_code(403);
            die('Invalid CSRF token. Go back and try again.');
        }
    }
}
