<?php

declare(strict_types=1);

function e(string $value): string
{
    return htmlspecialchars($value, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

function old(string $key, string $default = ''): string
{
    return e($_SESSION['_old'][$key] ?? $default);
}

function setOld(array $data): void
{
    $_SESSION['_old'] = $data;
}

function clearOld(): void
{
    unset($_SESSION['_old']);
}

function csrf_field(): string
{
    return \App\Middleware\Csrf::field();
}

function flash_error(): ?string
{
    return \App\Session\SessionManager::getFlash('error');
}

function flash_success(): ?string
{
    return \App\Session\SessionManager::getFlash('success');
}

function config(string $key): mixed
{
    static $config = null;
    if ($config === null) {
        $config = require dirname(__DIR__) . '/config/app.php';
    }

    $keys = explode('.', $key);
    $value = $config;
    foreach ($keys as $k) {
        $value = $value[$k] ?? null;
    }
    return $value;
}
