<?php

use App\Auth\Auth;
use App\Auth\TwoFactor;
use App\Database\DB;
use App\Session\SessionManager;

$userId = SessionManager::get('2fa_user_id');

if (!$userId) {
    header('Location: /login');
    exit;
}

$code = trim($_POST['code'] ?? '');

if (empty($code) || !TwoFactor::verifyForUser($userId, $code)) {
    SessionManager::flash('error', 'Invalid code. Please try again.');
    header('Location: /2fa/verify');
    exit;
}

$user = DB::fetch('SELECT * FROM users WHERE id = ?', [$userId]);
SessionManager::remove('2fa_user_id');

Auth::loginUser($user);

$remember = SessionManager::get('2fa_remember', false);
SessionManager::remove('2fa_remember');

if ($remember) {
    $token = Auth::createRememberToken($user['id']);
    setcookie('remember_token', $token, [
        'expires'  => time() + (30 * 86400),
        'path'     => '/',
        'httponly'  => true,
        'samesite' => 'Lax',
    ]);
}

header('Location: /dashboard');
exit;
