<?php

use App\Session\SessionManager;

if (!SessionManager::has('2fa_user_id')) {
    header('Location: /login');
    exit;
}

$pageTitle = 'Two-Factor Authentication';
$heading   = 'Enter your code';
$subtitle  = 'Open your authenticator app and enter the 6-digit code.';
$icon      = '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/></svg>';

ob_start();
?>
<form method="POST" action="/2fa/verify" class="auth-form" novalidate>
    <?= csrf_field() ?>

    <div class="form-group">
        <div class="input-wrapper">
            <svg class="input-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="2" y="6" width="20" height="12" rx="2"/><path d="M12 12h.01"/><path d="M17 12h.01"/><path d="M7 12h.01"/></svg>
            <input type="text" name="code" placeholder="6-digit code" maxlength="6" pattern="[0-9]{6}" inputmode="numeric" required autofocus autocomplete="one-time-code" class="tracking-widest">
        </div>
    </div>

    <button type="submit" class="btn btn-primary">Verify</button>
</form>
<?php
$content = ob_get_clean();
$footerLink = '<a href="/login">← Back to login</a>';

require dirname(__DIR__) . '/layouts/auth.php';
