<?php

use App\Auth\PasswordReset;
use App\Auth\Validator;
use App\Mail\Mailer;
use App\Middleware\RateLimiter;
use App\Session\SessionManager;

$rateCfg = config('rate_limit');
RateLimiter::check('reset', $rateCfg['reset'], $rateCfg['window']);

$email = trim($_POST['email'] ?? '');

$v = new Validator();
$v->email($email);

if ($v->fails()) {
    setOld(['email' => $email]);
    SessionManager::flash('error', $v->firstError());
    header('Location: /forgot-password');
    exit;
}

RateLimiter::hit('reset');

$token = PasswordReset::createToken($email);

if ($token) {
    $resetUrl = config('url') . '/reset-password?token=' . $token . '&email=' . urlencode($email);
    $mailer = new Mailer(config('smtp'));
    $mailer->sendPasswordReset($email, $resetUrl, config('name'));
}

SessionManager::flash('success', 'If that email exists, we sent a reset link. Check your inbox.');
clearOld();
header('Location: /forgot-password');
exit;
