<?php

use App\Middleware\AuthGuard;

AuthGuard::requireGuest();

$pageTitle = 'Forgot Password';
$heading   = 'Reset your password';
$subtitle  = 'Enter your email and we\'ll send you a reset link.';
$icon      = '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><path d="M9.09 9a3 3 0 015.83 1c0 2-3 3-3 3"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>';

ob_start();
?>
<form method="POST" action="/forgot-password" class="auth-form" novalidate>
    <?= csrf_field() ?>

    <div class="form-group">
        <div class="input-wrapper">
            <svg class="input-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="2" y="4" width="20" height="16" rx="2"/><path d="M22 7l-10 6L2 7"/></svg>
            <input type="email" name="email" placeholder="Email" value="<?= old('email') ?>" required autofocus autocomplete="email">
        </div>
    </div>

    <button type="submit" class="btn btn-primary">Send Reset Link</button>
</form>
<?php
$content = ob_get_clean();
$footerLink = 'Remember your password? <a href="/login">Sign in</a>';

require dirname(__DIR__) . '/layouts/auth.php';
