<?php

use App\Auth\Auth;
use App\Auth\Validator;
use App\Middleware\RateLimiter;
use App\Session\SessionManager;

$rateCfg = config('rate_limit');
RateLimiter::check('login', $rateCfg['login'], $rateCfg['window']);

$email    = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';
$remember = !empty($_POST['remember']);

$v = new Validator();
$v->email($email)->required($password, 'password', 'Password');

if ($v->fails()) {
    setOld(['email' => $email]);
    SessionManager::flash('error', $v->firstError());
    header('Location: /login');
    exit;
}

RateLimiter::hit('login');

$result = Auth::attempt($email, $password);

if (!$result['ok']) {
    setOld(['email' => $email]);
    SessionManager::flash('error', $result['error']);
    header('Location: /login');
    exit;
}

if ($result['requires_2fa'] ?? false) {
    SessionManager::set('2fa_remember', $remember);
    header('Location: /2fa/verify');
    exit;
}

if ($remember) {
    $token = Auth::createRememberToken(SessionManager::get('user_id'));
    setcookie('remember_token', $token, [
        'expires'  => time() + (30 * 86400),
        'path'     => '/',
        'httponly'  => true,
        'samesite' => 'Lax',
    ]);
}

clearOld();
header('Location: /dashboard');
exit;
