<?php

use App\Middleware\AuthGuard;

AuthGuard::requireGuest();

$pageTitle = 'Sign In';
$heading   = 'Sign in with email';
$subtitle  = 'Enter your credentials to access your account.';
$icon      = '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 3h4a2 2 0 012 2v14a2 2 0 01-2 2h-4"/><polyline points="10 17 15 12 10 7"/><line x1="15" y1="12" x2="3" y2="12"/></svg>';

ob_start();
?>
<form method="POST" action="/login" class="auth-form" novalidate>
    <?= csrf_field() ?>

    <div class="form-group">
        <div class="input-wrapper">
            <svg class="input-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="2" y="4" width="20" height="16" rx="2"/><path d="M22 7l-10 6L2 7"/></svg>
            <input type="email" name="email" placeholder="Email" value="<?= old('email') ?>" required autocomplete="email" autofocus>
        </div>
    </div>

    <div class="form-group">
        <div class="input-wrapper">
            <svg class="input-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"/><path d="M7 11V7a5 5 0 0110 0v4"/></svg>
            <input type="password" name="password" placeholder="Password" required autocomplete="current-password">
            <button type="button" class="toggle-password" tabindex="-1" aria-label="Show password">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/><circle cx="12" cy="12" r="3"/></svg>
            </button>
        </div>
    </div>

    <div class="form-row">
        <label class="checkbox-label">
            <input type="checkbox" name="remember" value="1">
            <span>Remember me</span>
        </label>
        <a href="/forgot-password" class="form-link">Forgot password?</a>
    </div>

    <button type="submit" class="btn btn-primary">Get Started</button>
</form>
<?php
$content = ob_get_clean();
$footerLink = 'Don\'t have an account? <a href="/register">Sign up</a>';

require dirname(__DIR__) . '/layouts/auth.php';
