<?php

use App\Auth\Auth;
use App\Auth\Validator;
use App\Mail\Mailer;
use App\Middleware\RateLimiter;
use App\Session\SessionManager;

$rateCfg = config('rate_limit');
RateLimiter::check('register', $rateCfg['register'], $rateCfg['window']);

$name     = trim($_POST['name'] ?? '');
$email    = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';
$confirm  = $_POST['password_confirmation'] ?? '';

$v = new Validator();
$v->required($name, 'name', 'Name')
  ->email($email)
  ->passwordStrength($password)
  ->match($password, $confirm, 'password_confirmation', 'Passwords do not match.');

if ($v->fails()) {
    setOld(['name' => $name, 'email' => $email]);
    SessionManager::flash('error', $v->firstError());
    header('Location: /register');
    exit;
}

RateLimiter::hit('register');

$result = Auth::register($name, $email, $password);

if (!$result['ok']) {
    setOld(['name' => $name, 'email' => $email]);
    SessionManager::flash('error', $result['error']);
    header('Location: /register');
    exit;
}

$mailer = new Mailer(config('smtp'));
$mailer->sendWelcome($email, $name, config('url') . '/login', config('name'));

clearOld();
SessionManager::flash('success', 'Account created! You can now sign in.');
header('Location: /login');
exit;
