<?php

use App\Middleware\AuthGuard;

AuthGuard::requireGuest();

$pageTitle = 'Create Account';
$heading   = 'Create your account';
$subtitle  = 'Get started for free. No credit card required.';
$icon      = '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M16 21v-2a4 4 0 00-4-4H5a4 4 0 00-4 4v2"/><circle cx="8.5" cy="7" r="4"/><line x1="20" y1="8" x2="20" y2="14"/><line x1="23" y1="11" x2="17" y2="11"/></svg>';

ob_start();
?>
<form method="POST" action="/register" class="auth-form" novalidate>
    <?= csrf_field() ?>

    <div class="form-group">
        <div class="input-wrapper">
            <svg class="input-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M20 21v-2a4 4 0 00-4-4H8a4 4 0 00-4 4v2"/><circle cx="12" cy="7" r="4"/></svg>
            <input type="text" name="name" placeholder="Full name" value="<?= old('name') ?>" required autofocus autocomplete="name">
        </div>
    </div>

    <div class="form-group">
        <div class="input-wrapper">
            <svg class="input-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="2" y="4" width="20" height="16" rx="2"/><path d="M22 7l-10 6L2 7"/></svg>
            <input type="email" name="email" placeholder="Email" value="<?= old('email') ?>" required autocomplete="email">
        </div>
    </div>

    <div class="form-group">
        <div class="input-wrapper">
            <svg class="input-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"/><path d="M7 11V7a5 5 0 0110 0v4"/></svg>
            <input type="password" name="password" placeholder="Password" required autocomplete="new-password">
            <button type="button" class="toggle-password" tabindex="-1" aria-label="Show password">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/><circle cx="12" cy="12" r="3"/></svg>
            </button>
        </div>
    </div>

    <div class="form-group">
        <div class="input-wrapper">
            <svg class="input-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/></svg>
            <input type="password" name="password_confirmation" placeholder="Confirm password" required autocomplete="new-password">
        </div>
    </div>

    <button type="submit" class="btn btn-primary">Create Account</button>
</form>
<?php
$content = ob_get_clean();
$footerLink = 'Already have an account? <a href="/login">Sign in</a>';

require dirname(__DIR__) . '/layouts/auth.php';
