<?php

use App\Auth\PasswordReset;
use App\Auth\Validator;
use App\Session\SessionManager;

$token   = $_POST['token'] ?? '';
$email   = $_POST['email'] ?? '';
$pass    = $_POST['password'] ?? '';
$confirm = $_POST['password_confirmation'] ?? '';

$v = new Validator();
$v->passwordStrength($pass)
  ->match($pass, $confirm, 'password_confirmation', 'Passwords do not match.');

if ($v->fails()) {
    SessionManager::flash('error', $v->firstError());
    header("Location: /reset-password?token={$token}&email=" . urlencode($email));
    exit;
}

if (PasswordReset::reset($token, $email, $pass)) {
    SessionManager::flash('success', 'Password updated. You can now sign in.');
    header('Location: /login');
} else {
    SessionManager::flash('error', 'Invalid or expired reset link.');
    header('Location: /forgot-password');
}
exit;
