<?php

use App\Auth\PasswordReset;
use App\Middleware\AuthGuard;
use App\Session\SessionManager;

AuthGuard::requireGuest();

$token = $_GET['token'] ?? '';
$email = $_GET['email'] ?? '';

if (empty($token) || empty($email) || !PasswordReset::validate($token, $email)) {
    SessionManager::flash('error', 'Invalid or expired reset link.');
    header('Location: /forgot-password');
    exit;
}

$pageTitle = 'New Password';
$heading   = 'Set a new password';
$subtitle  = 'Choose a strong password for your account.';
$icon      = '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 2l-2 2m-7.61 7.61a5.5 5.5 0 11-7.778 7.778 5.5 5.5 0 017.777-7.777zm0 0L15.5 7.5m0 0l3 3L22 7l-3-3m-3.5 3.5L19 4"/></svg>';

ob_start();
?>
<form method="POST" action="/reset-password" class="auth-form" novalidate>
    <?= csrf_field() ?>
    <input type="hidden" name="token" value="<?= e($token) ?>">
    <input type="hidden" name="email" value="<?= e($email) ?>">

    <div class="form-group">
        <div class="input-wrapper">
            <svg class="input-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"/><path d="M7 11V7a5 5 0 0110 0v4"/></svg>
            <input type="password" name="password" placeholder="New password" required autofocus autocomplete="new-password">
            <button type="button" class="toggle-password" tabindex="-1" aria-label="Show password">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/><circle cx="12" cy="12" r="3"/></svg>
            </button>
        </div>
    </div>

    <div class="form-group">
        <div class="input-wrapper">
            <svg class="input-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/></svg>
            <input type="password" name="password_confirmation" placeholder="Confirm new password" required autocomplete="new-password">
        </div>
    </div>

    <button type="submit" class="btn btn-primary">Reset Password</button>
</form>
<?php
$content = ob_get_clean();

require dirname(__DIR__) . '/layouts/auth.php';
