<?php

use App\Auth\TwoFactor;
use App\Middleware\AuthGuard;
use App\Session\SessionManager;

AuthGuard::requireAuth();

$code = trim($_POST['code'] ?? '');

if (empty($code) || !TwoFactor::verifyForUser(AuthGuard::userId(), $code)) {
    SessionManager::flash('error', 'Invalid code. 2FA was not disabled.');
    header('Location: /settings/2fa');
    exit;
}

TwoFactor::disable(AuthGuard::userId());

SessionManager::flash('success', 'Two-factor authentication has been disabled.');
header('Location: /settings');
exit;
