<?php

use App\Auth\TwoFactor;
use App\Middleware\AuthGuard;
use App\Session\SessionManager;

AuthGuard::requireAuth();

$code   = trim($_POST['code'] ?? '');
$secret = SessionManager::get('2fa_setup_secret');

if (!$secret || empty($code)) {
    SessionManager::flash('error', 'Something went wrong. Please try again.');
    header('Location: /settings/2fa');
    exit;
}

if (!TwoFactor::verify($secret, $code)) {
    SessionManager::flash('error', 'Invalid code. Make sure your authenticator is synced.');
    header('Location: /settings/2fa');
    exit;
}

TwoFactor::enable(AuthGuard::userId(), $secret);
SessionManager::remove('2fa_setup_secret');

SessionManager::flash('success', 'Two-factor authentication enabled.');
header('Location: /settings');
exit;
