<?php

use App\Auth\Auth;
use App\Auth\TwoFactor;
use App\Middleware\AuthGuard;
use App\Session\SessionManager;

AuthGuard::requireAuth();

$user = Auth::user();
$pageTitle = '2FA Setup';
$has2fa = !empty($user['two_factor_secret']);

if (!$has2fa) {
    $secret = SessionManager::get('2fa_setup_secret');
    if (!$secret) {
        $secret = TwoFactor::generateSecret();
        SessionManager::set('2fa_setup_secret', $secret);
    }
    $qrSvg = TwoFactor::qrCodeSvg($secret, $user['email'], config('name'));
}

ob_start();
?>
<div class="page-header">
    <h1>Two-Factor Authentication</h1>
</div>

<?php if ($has2fa): ?>
    <div class="settings-section">
        <p>Two-factor authentication is <span class="badge badge-green">enabled</span>.</p>
        <p class="text-muted">To disable it, confirm with your authenticator code below.</p>

        <form method="POST" action="/settings/2fa/disable" class="settings-form">
            <?= csrf_field() ?>
            <div class="form-group">
                <label for="code">Authenticator code</label>
                <input type="text" id="code" name="code" maxlength="6" pattern="[0-9]{6}" inputmode="numeric" required autocomplete="one-time-code">
            </div>
            <button type="submit" class="btn btn-danger">Disable 2FA</button>
        </form>
    </div>
<?php else: ?>
    <div class="settings-section">
        <p>Scan this QR code with your authenticator app (Google Authenticator, Authy, etc.):</p>

        <div class="qr-container">
            <?= $qrSvg ?>
        </div>

        <p class="text-small text-muted">Or enter this key manually: <code><?= e($secret) ?></code></p>

        <form method="POST" action="/settings/2fa" class="settings-form">
            <?= csrf_field() ?>
            <div class="form-group">
                <label for="code">Enter the 6-digit code from your app to confirm</label>
                <input type="text" id="code" name="code" maxlength="6" pattern="[0-9]{6}" inputmode="numeric" required autocomplete="one-time-code">
            </div>
            <button type="submit" class="btn btn-primary">Enable 2FA</button>
        </form>
    </div>
<?php endif; ?>
<?php
$content = ob_get_clean();
require dirname(__DIR__) . '/layouts/dashboard.php';
