<?php

use App\Middleware\AuthGuard;
use App\Auth\Auth;

AuthGuard::requireAuth();

$user = Auth::user();
$pageTitle = 'Dashboard';

ob_start();
?>
<div class="page-header">
    <h1>Welcome back, <?= e($user['name']) ?></h1>
    <p class="text-muted">This is your dashboard. Build something great.</p>
</div>

<div class="card-grid">
    <div class="card">
        <h3>Profile</h3>
        <p class="text-muted"><?= e($user['email']) ?></p>
        <p class="text-small text-muted">Member since <?= date('M j, Y', strtotime($user['created_at'])) ?></p>
    </div>

    <div class="card">
        <h3>Security</h3>
        <p class="text-muted">
            Two-factor auth:
            <?php if ($user['two_factor_secret']): ?>
                <span class="badge badge-green">Enabled</span>
            <?php else: ?>
                <span class="badge badge-gray">Disabled</span>
            <?php endif; ?>
        </p>
        <a href="/settings/2fa" class="card-link">Configure &rarr;</a>
    </div>

    <div class="card">
        <h3>Settings</h3>
        <p class="text-muted">Manage your account, change your password, and more.</p>
        <a href="/settings" class="card-link">Go to settings &rarr;</a>
    </div>
</div>
<?php
$content = ob_get_clean();
require dirname(__DIR__) . '/layouts/dashboard.php';
