<?php

use App\Auth\Auth;
use App\Auth\AuditLog;
use App\Auth\Validator;
use App\Database\DB;
use App\Middleware\AuthGuard;
use App\Session\SessionManager;

AuthGuard::requireAuth();

$current = $_POST['current_password'] ?? '';
$newPass = $_POST['new_password'] ?? '';
$confirm = $_POST['new_password_confirmation'] ?? '';

$v = new Validator();
$v->required($current, 'current_password', 'Current password')
  ->passwordStrength($newPass, 'new_password')
  ->match($newPass, $confirm, 'new_password_confirmation', 'New passwords do not match.');

if ($v->fails()) {
    SessionManager::flash('error', $v->firstError());
    header('Location: /settings');
    exit;
}

$user = DB::fetch('SELECT * FROM users WHERE id = ?', [AuthGuard::userId()]);

if (!password_verify($current, $user['password'])) {
    SessionManager::flash('error', 'Current password is incorrect.');
    header('Location: /settings');
    exit;
}

$hash = password_hash($newPass, PASSWORD_BCRYPT, ['cost' => 12]);
DB::update('users', ['password' => $hash, 'updated_at' => date('Y-m-d H:i:s')], 'id = ?', [$user['id']]);

AuditLog::log(AuditLog::PASSWORD_CHANGED, $user['id']);

SessionManager::flash('success', 'Password updated.');
header('Location: /settings');
exit;
