<?php

use App\Middleware\AuthGuard;
use App\Auth\Auth;

AuthGuard::requireAuth();

$user = Auth::user();
$pageTitle = 'Settings';

ob_start();
?>
<div class="page-header">
    <h1>Account Settings</h1>
</div>

<div class="settings-section">
    <h2>Change Password</h2>
    <form method="POST" action="/settings/password" class="settings-form" novalidate>
        <?= csrf_field() ?>
        <div class="form-group">
            <label for="current_password">Current password</label>
            <input type="password" id="current_password" name="current_password" required autocomplete="current-password">
        </div>
        <div class="form-group">
            <label for="new_password">New password</label>
            <input type="password" id="new_password" name="new_password" required autocomplete="new-password">
        </div>
        <div class="form-group">
            <label for="new_password_confirmation">Confirm new password</label>
            <input type="password" id="new_password_confirmation" name="new_password_confirmation" required autocomplete="new-password">
        </div>
        <button type="submit" class="btn btn-primary">Update Password</button>
    </form>
</div>

<div class="settings-section">
    <h2>Two-Factor Authentication</h2>
    <?php if ($user['two_factor_secret']): ?>
        <p>2FA is <span class="badge badge-green">enabled</span> on your account.</p>
        <a href="/settings/2fa" class="btn btn-secondary">Manage 2FA</a>
    <?php else: ?>
        <p>Add an extra layer of security to your account.</p>
        <a href="/settings/2fa" class="btn btn-primary">Enable 2FA</a>
    <?php endif; ?>
</div>
<?php
$content = ob_get_clean();
require dirname(__DIR__) . '/layouts/dashboard.php';
