<?php if (!defined('AUTH_LAYOUT')) define('AUTH_LAYOUT', true); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($pageTitle ?? 'Sign In') ?> — <?= e(config('name')) ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/assets/css/auth.css">
</head>
<body>
    <div class="auth-bg">
        <div class="cloud cloud-1"></div>
        <div class="cloud cloud-2"></div>
        <div class="cloud cloud-3"></div>
    </div>

    <div class="auth-wrapper">
        <div class="auth-brand">
            <div class="brand-icon">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M13 2L3 14h9l-1 8 10-12h-9l1-8z"/>
                </svg>
            </div>
            <span class="brand-name"><?= e(config('name')) ?></span>
        </div>

        <div class="auth-card">
            <?php if ($icon ?? false): ?>
                <div class="auth-icon"><?= $icon ?></div>
            <?php endif; ?>

            <h1 class="auth-title"><?= e($heading ?? 'Sign In') ?></h1>

            <?php if ($subtitle ?? false): ?>
                <p class="auth-subtitle"><?= e($subtitle) ?></p>
            <?php endif; ?>

            <?php $error = flash_error(); ?>
            <?php $success = flash_success(); ?>

            <?php if ($error): ?>
                <div class="alert alert-error"><?= e($error) ?></div>
            <?php endif; ?>

            <?php if ($success): ?>
                <div class="alert alert-success"><?= e($success) ?></div>
            <?php endif; ?>

            <?= $content ?? '' ?>
        </div>

        <?php if ($footerLink ?? false): ?>
            <p class="auth-footer"><?= $footerLink ?></p>
        <?php endif; ?>
    </div>

    <script src="/assets/js/auth.js"></script>
</body>
</html>
