<?php

/**
 * Configuration File
 * Copy this to config.php and customize as needed
 */

return [
    // Application settings
    'app' => [
        'name' => 'Scientific Calculator',
        'version' => '1.0.0',
        'timezone' => 'UTC',
        'debug' => false,
    ],

    // Data storage settings
    'storage' => [
        'driver' => 'json',
        'path' => __DIR__ . '/../data',
        'conversions_file' => 'conversions.json',
        'max_history' => 100,
    ],

    // Calculator settings
    'calculator' => [
        'max_decimal_places' => 10,
        'max_factorial' => 170,
        'default_angle_unit' => 'radians', // radians or degrees
    ],

    // Converter settings
    'converter' => [
        'precision' => 6,
        'supported_types' => ['length', 'time', 'mass', 'temperature'],
    ],

    // Security settings
    'security' => [
        'session_lifetime' => 3600,
        'csrf_protection' => true,
    ],

    // UI settings
    'ui' => [
        'theme' => 'gradient', // gradient, light, dark
        'results_format' => 'number', // number, scientific, engineering
    ],
];
