# Weather App (Single Root) — Landing 1–3 + Forecast UI 1–3

A portfolio-ready **Weather App Hub** built with **Vanilla HTML/CSS/JS**.

Everything runs from one entry page:

- ✅ `/weather-app/index.html`

This single-page app includes:
- ✅ **Landing switcher** (Design 1–3)
- ✅ **Forecast UI switcher** (UI 1–3)
- ✅ **Live OpenWeather data** (Current + 3-hour forecast)
- ✅ **Map widget** (OpenStreetMap embed — no key needed)
- ✅ **Font Awesome weather icons**
- ✅ **API key modal** (stores your key in browser `localStorage`)

---

## 1) File structure (cPanel / public_html)

Upload the project folder like this:

```txt
public_html/
└── weather-app/
    ├── index.html
    ├── styles.css
    ├── app.js
    └── READ.md
```

Then open:

```txt
https://YOURDOMAIN.com/weather-app/
```

(or)

```txt
https://YOURDOMAIN.com/weather-app/index.html
```

> On most servers, visiting `/weather-app/` automatically loads `index.html`.

---

## 2) Get a FREE OpenWeather API key

OpenWeather requires an API key to fetch live data.

### Step A — Create an account
Sign up:

```txt
https://home.openweathermap.org/users/sign_up
```

### Step B — Find / create your API key
After login, go to:

```txt
https://home.openweathermap.org/api_keys
```

Copy your key (a long string like `a1b2c3...`).

⚠️ Sometimes **new keys take a short time to activate**.  
If you see a 401 error, wait a bit and try again.

---

## 3) Add your API key inside the app (recommended)

This project uses an **API Key modal**:

1. Open `/weather-app/`
2. Click **API Key** (top right)
3. Paste your OpenWeather key
4. Click **Save**

✅ The key is saved in your browser using `localStorage` so you don’t paste it again.

### Clear the key
Open the **API Key** modal, remove the key text, then save (or refresh and set again).

---

## 4) What this app does (features)

### A) Landing Designs (1–3)
Landing buttons switch the global theme:
- `theme-1`
- `theme-2`
- `theme-3`

This is purely visual branding/appearance.

### B) Forecast UIs (1–3)
Forecast UI buttons switch between three layouts:
- **UI 1:** Light “white-card” surface style (includes green action button)
- **UI 2:** Dark dashboard widget overlay + side forecast list
- **UI 3:** Mobile-first card layout (blue dashboard style)

All three UIs show the same data; only the layout changes.

### C) Live weather data
For each searched city, the app shows:
- Current temperature (°C)
- Description + OpenWeather icon
- Feels-like temperature
- Humidity (%)
- Wind speed (m/s)
- Pressure (hPa)
- Clouds (%)
- Precipitation (mm) when available
- Forecast cards/list (next 8 time steps)

### D) Map widget (no API key)
The map widget uses **OpenStreetMap embed** based on returned latitude/longitude.

---

## 5) API endpoints used (OpenWeather)

### Current Weather
```txt
https://api.openweathermap.org/data/2.5/weather?q=CITY&appid=KEY&units=metric
```

### 3-hour Forecast
```txt
https://api.openweathermap.org/data/2.5/forecast?q=CITY&appid=KEY&units=metric
```

**Units:** this project uses Metric (`units=metric`).

To use Fahrenheit (optional), change `units=metric` to `units=imperial` in `app.js`.

---

## 6) Customize the project

### Change the default startup city
In `app.js`, find:

```js
state.city = "London";
```

Change to your preference, e.g.:

```js
state.city = "Kampala";
```

### Change how many forecast items appear
In `app.js`, forecast is trimmed like this:

```js
(f.list || []).slice(0, 8)
```

Change `8` to `6`, `10`, etc.

---

## 7) Troubleshooting

### “No API key set”
Click **API Key** and paste your key.

### 401 Unauthorized
- Key is wrong OR not activated yet.
- Wait a bit and try again.

### City not found
- Check spelling
- Try a bigger/standard city name (e.g. “Berlin”, “London”, “Paris”)

### Map not showing
Some networks block embeds.
Try another browser/network.

---

## 8) GitHub setup (quick)

1. Create repo (e.g. `weather-app`)
2. Upload these files:
   - `index.html`
   - `styles.css`
   - `app.js`
   - `READ.md`
3. Enable GitHub Pages:
   - Repo Settings → Pages → Deploy from branch → `main` → `/root`
4. Your site becomes:
   - `https://USERNAME.github.io/weather-app/`

---

## 9) Tech stack

- HTML
- CSS
- Vanilla JavaScript
- OpenWeather API (live weather + forecast)
- OpenStreetMap embed (map widget)
- Font Awesome (icons)

---

## License
Use any license you want. Common for portfolio demos: **MIT**.
