# Weather Dashboard (OpenWeather-style UI)

This is a front-end-only weather dashboard with an OpenWeather-style layout:
- 3-column layout (sidebar / map+table / right events panel)
- Live OpenWeather map tiles (temp/precip/pressure/wind/clouds)
- Live current weather + forecast
- Nearby city labels (click a label to jump)

## Setup
1) Copy `config.example.js` to `config.js`
2) Put your OpenWeather API key inside `config.js`

**Important:** If you deploy to GitHub Pages, the API key is visible (front-end apps can’t hide keys).
Use a separate “portfolio key” if you want.

## Run locally (recommended)
Use a simple local server so caching and paths work:

- VSCode: install “Live Server” and click “Go Live”
- Or Python:
  - `python -m http.server 5500`
  - open http://localhost:5500/weather-app/

## Fix: “Everything stuck top-left”
That means your `styles.css` wasn’t loaded (wrong filename/path or cache). This project includes a tiny “fallback” CSS inside index.html, but for the full look you must have:

weather-app/
  index.html
  styles.css
  app.js
  config.js

Then hard-refresh (Ctrl+Shift+R).
