# Weather Dashboard — Design 2 (OpenWeather-style UI)

A sleek **OpenWeather-inspired weather dashboard** built with **vanilla HTML/CSS/JS** + **OpenWeatherMap APIs**.  
This version (“Design 2”) focuses on a **dark, premium dashboard layout** with a sidebar, map overlays, a live weather widget, and a forecast table — all in one screen.

## Preview (What you’ll see)
- Left sidebar with a single primary nav: **Dashboard**
- Center panel with:
  - Search (city/zip)
  - Layer toggles (Temperature / Precipitation / Pressure / Wind / Clouds)
  - Interactive map with OpenWeather tile overlays
  - Floating live weather widget (temp, wind, humidity, pressure, clouds)
  - Timeline slider + selection state
- Right panel with **Trigger Events / Alerts** cards
- Bottom **Forecast** table (time, weather icon, precip probability, temp, humidity)

---

## Features
✅ **City search** (OpenWeather Geocoding)  
✅ **Live current weather** (OpenWeather Current Weather API)  
✅ **Forecast timeline** (5-day / 3-hour forecast API)  
✅ **Map overlays** (OpenWeather tile layers)  
✅ **Nearby city markers** (Find API) — click to jump  
✅ **Alerts panel** (One Call API, when available for your plan/region)  
✅ Responsive layout (right panel collapses on smaller screens)

---

## Tech Stack
- **HTML / CSS / Vanilla JavaScript**
- **Leaflet.js** (map)
- **OpenWeatherMap APIs**
  - Geocoding API
  - Current Weather API
  - 5 Day / 3 Hour Forecast API
  - (Optional) One Call API for alerts
  - Weather Map Tiles for overlays

---

## Getting Started

### 1) Add your OpenWeather API key
Create a `config.js` file (or edit the existing `config.example.js`) and set:

```js
window.OPENWEATHER_API_KEY = "YOUR_KEY_HERE";
